/*
 * @(#)hprof_global.h	1.3 98/08/23
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_GLOBALS_H
#define _HPROF_GLOBALS_H

#include "jvmpi.h"
#include <stdlib.h>

#define TRUE  1
#define FALSE 0

extern JavaVM *jvm;

extern int hprof_is_on;            /* whether hprof is enabled */
extern int hprof_fd;	           /* Non-zero file or socket descriptor. */
extern int hprof_socket_p;         /* True if hprof_fd is a socket. */

extern int max_trace_depth;
extern int prof_trace_depth;
extern int thread_in_traces;
extern int lineno_in_traces;
extern char output_format;
extern float hprof_cutoff_point;
extern int dump_on_exit;
extern int cpu_sampling;
extern int monitor_sampling;
extern int monitor_tracing;
extern int heap_dump;
extern int alloc_sites;

/* cpu timing output formats */
#define OLD_PROF_OUTPUT_FORMAT 0
#define NEW_PROF_OUTPUT_FORMAT 1
extern int cpu_timing;
extern int timing_format;

extern jlong total_alloced_bytes;
extern jlong total_alloced_instances;
extern long total_live_bytes;
extern long total_live_instances;

/* Data access Lock */
extern JVMPI_RawMonitor data_access_lock;
/* Dump lock */
extern JVMPI_RawMonitor hprof_dump_lock;

/* profiler interface */
extern JVMPI_Interface *hprof_jvm_interface;
#define CALL(f) (hprof_jvm_interface->f)

/* version */
#define HPROF_HEADER "JAVA PROFILE 1.0.1"

void *hprof_calloc(unsigned int size);
#define hprof_free free

extern unsigned int micro_sec_ticks;

#endif /* _HPROF_GLOBALS_H */
