/*
 * @(#)hprof_md.c	1.2 98/07/08
 *
 * Copyright 1994-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#include <windows.h>
#include <mmsystem.h>

#include "jni.h"
#include "jlong.h"
#include "hprof.h"

int hprof_send(int s, const char *msg, int len, int flags)
{
    return send(s, msg, len, flags);
}

int hprof_write(int filedes, const void *buf, size_t nbyte)
{
    return write(filedes, buf, nbyte);
}

jint hprof_get_milliticks()
{
    return(timeGetTime());
}

#define FT2JLONG(ft) \
	((jlong)(ft).dwHighDateTime << 32 | (jlong)(ft).dwLowDateTime)

jlong hprof_get_timemillis()
{
    static jlong fileTime_1_1_70 = 0;
    SYSTEMTIME st0;
    FILETIME   ft0;

    if (fileTime_1_1_70 == 0) {
        /* Initialize fileTime_1_1_70 -- the Win32 file time of midnight
	 * 1/1/70.
         */ 

        memset(&st0, 0, sizeof(st0));
        st0.wYear  = 1970;
        st0.wMonth = 1;
        st0.wDay   = 1;
        SystemTimeToFileTime(&st0, &ft0);
	fileTime_1_1_70 = FT2JLONG(ft0);
    } 

    GetSystemTime(&st0);
    SystemTimeToFileTime(&st0, &ft0);

    return (FT2JLONG(ft0) - fileTime_1_1_70) / 10000;
}

HINSTANCE hJavaInst;

BOOL WINAPI
DllMain(HINSTANCE hinst, DWORD reason, LPVOID reserved)
{
    switch (reason) {
        case DLL_PROCESS_ATTACH:
            hJavaInst = hinst;
            break;
        default:
            break;
    }
    return TRUE;
}

void hprof_get_prelude_path(char *path)
{
    char home_dir[MAX_PATH];

    GetModuleFileName(hJavaInst, home_dir, MAX_PATH);
    *(strrchr(home_dir, '\\')) = '\0';
    *(strrchr(home_dir, '\\')) = '\0';

    sprintf(path, "%s\\lib\\jvm.hprof.txt", home_dir);
}
